package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B23T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (09/05/07)
 */
public class P06B23T00DAO {

	static private P06B23T00DAO instance = null;

	public static P06B23T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B23T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B23T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B23T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B23T00Datatype select(String codigoPK) throws Exception{
		P06BLog.send(2,this, "Inicio P06B23T00Datatype-select");
		P06B23T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,codigoPK.toUpperCase());
        	lrst = lstm.executeQuery();
        	result = new P06B23T00Datatype();
	        if (lrst.next()) {
	        	result.setClave(lrst.getString(P06BTablas.P06B_P06B23_EA_CLAVE));
				result.setEntidad(lrst.getString(P06BTablas.P06B_P06B23_EA_ENTIDAD));
				result.setCif(lrst.getString(P06BTablas.P06B_P06B23_EA_CIF)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_CIF));
				result.setTelefono(lrst.getString(P06BTablas.P06B_P06B23_EA_TELEFONO)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_TELEFONO));
				result.setEstado(lrst.getString(P06BTablas.P06B_P06B23_EA_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_ESTADO));
				result.setBaja(lrst.getBoolean(P06BTablas.P06B_P06B23_EA_BAJA));
			}
	        P06BLog.send(2,this, "Fin P06B23T00Datatype-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}


	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param cif.
    *            clave primaria
    * @return un objeto P06B23T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B23T00Datatype selectByCIF(String cif) throws Exception{
		P06BLog.send(2,this, "Inicio P06B23T00Datatype-select");
		P06B23T00Datatype result = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_CIF;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,cif.toUpperCase());
        	lrst = lstm.executeQuery();
        	result = new P06B23T00Datatype();
	        if (lrst.next()) {
	        	result.setClave(lrst.getString(P06BTablas.P06B_P06B23_EA_CLAVE));
				result.setEntidad(lrst.getString(P06BTablas.P06B_P06B23_EA_ENTIDAD));
				result.setCif(lrst.getString(P06BTablas.P06B_P06B23_EA_CIF)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_CIF));
				result.setTelefono(lrst.getString(P06BTablas.P06B_P06B23_EA_TELEFONO)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_TELEFONO));
				result.setEstado(lrst.getString(P06BTablas.P06B_P06B23_EA_ESTADO)==null?"":lrst.getString(P06BTablas.P06B_P06B23_EA_ESTADO));
				result.setBaja(lrst.getBoolean(P06BTablas.P06B_P06B23_EA_BAJA));
			}
	        P06BLog.send(2,this, "Fin P06B23T00Datatype-select");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e;
	    }catch (Exception e2) {
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepci�n
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return result;
	}


	private static String SELECT_BY_PK =
		"SELECT " +
		P06BTablas.P06B_P06B23_EA_CLAVE + ", " + P06BTablas.P06B_P06B23_EA_ENTIDAD + ", " +
		P06BTablas.P06B_P06B23_EA_CIF + ", " + P06BTablas.P06B_P06B23_EA_TELEFONO + ", " +
		P06BTablas.P06B_P06B23_EA_ESTADO + ", " + P06BTablas.P06B_P06B23_EA_BAJA +
		" FROM "+ P06BTablas.P06B_P06B23T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B23_EA_CLAVE + " = ?";
	private static String SELECT_BY_CIF =
		"SELECT " +
		P06BTablas.P06B_P06B23_EA_CLAVE + ", " + P06BTablas.P06B_P06B23_EA_ENTIDAD + ", " +
		P06BTablas.P06B_P06B23_EA_CIF + ", " + P06BTablas.P06B_P06B23_EA_TELEFONO + ", " +
		P06BTablas.P06B_P06B23_EA_ESTADO + ", " + P06BTablas.P06B_P06B23_EA_BAJA +
		" FROM "+ P06BTablas.P06B_P06B23T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B23_EA_CIF + " = ?";
}
